package gov.va.med.mhv.usermgmt.web.controller;

import java.util.Date;
import javax.faces.bean.ManagedBean;
import javax.faces.context.FacesContext;
import javax.faces.event.ComponentSystemEvent;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import gov.va.med.mhv.common.api.dto.UserProfileDTO;
import gov.va.med.mhv.common.api.exception.MHVException;
import gov.va.med.mhv.usermgmt.common.enums.ActivityActionTypeEnumeration;
import gov.va.med.mhv.usermgmt.common.enums.ActivityTypeEnumeration;
import gov.va.med.mhv.usermgmt.util.activity.ActivityHelper;

@ManagedBean
@Component
@Scope("session")
public class ManageAccountAccessController extends AbstractController {

	private static final long serialVersionUID = 1L;
	private static Logger log = LogManager.getLogger(ManageAccountAccessController.class);
	private boolean showBlock=false;
	private boolean showUnblock=false;
	private boolean blockAccess=false;
	private String reasonText = "";
	private String reasonTextEntered = "";
	private Long userProfileId;
	private UserProfileDTO userProfileDTO = null;
	private String liferayUserId = "";
	private String BLOCK_ACCESS = "Block Access";
	private String UNBLOCK_ACCESS = "Unblock Access";
	
	/**
	 *  Based on if the user has accounts or not the relevant part of the page is shown.
	 * @throws Exception 
	 */
	public void init(ComponentSystemEvent event) throws Exception{
		if(reasonTextEntered.equals("")) {
			FacesContext context = FacesContext.getCurrentInstance();
			if (!context.isPostback()){
				PortletRequest request = (PortletRequest) FacesContext.getCurrentInstance().getExternalContext().getRequest();
				PortletSession session = request.getPortletSession();
				Object profileId = session.getAttribute("LIFERAY_SHARED_userprofileid", PortletSession.APPLICATION_SCOPE);
				if(profileId != null){
					userProfileId = (Long)profileId;
					userProfileDTO = getUserProfile(userProfileId);
					liferayUserId = userProfileDTO.getUserName();
					if(userProfileDTO.getRestrictSIPAccess()) {
						setBlockAccess(true);
						setShowBlock(false);
						setShowUnblock(true);
					} else {
						setBlockAccess(false);
						setShowBlock(true);
						setShowUnblock(false);
					}
				}
			}
		}
		
	}
	
	//initialize the flags that are used to display different parts of the page
	private void initPageSections() {
		blockAccess=false;
		reasonText = "";
		reasonTextEntered = "";
	}

	public String confirmYes() throws MHVException {
		userProfileDTO.setRestrictSIPAccess(isBlockAccess());
		userProfileDTO.setRestrictSIPAccessBy(liferayUserId.toString());
		userProfileDTO.setRestrictSIPAccessDate(new Date());
		userProfileDTO.setRestrictSIPAccessReason(getReasonText().toString());
		try {
			this.userMgmtService.saveUserProfile(userProfileDTO);
		} catch (Exception e) {
			e.printStackTrace();
		}
		if(isBlockAccess()) {
			accountValidatorService.createAccountActivityLog(ActivityHelper.createActivityDTOForSelf(userProfileDTO.getId(), true, ActivityTypeEnumeration.SIGN_IN_PARTNERS, ActivityActionTypeEnumeration.BLOCK_ACCESS, "None"));
			setShowUnblock(true);
			setShowBlock(false);
			setReasonText("");
			setReasonTextEntered("");
		} else {
			accountValidatorService.createAccountActivityLog(ActivityHelper.createActivityDTOForSelf(userProfileDTO.getId(), true, ActivityTypeEnumeration.SIGN_IN_PARTNERS, ActivityActionTypeEnumeration.UNBLOCK_ACCESS, "None"));
			setShowUnblock(false);
			setShowBlock(true);
			setReasonText("");
			setReasonTextEntered("");
		}
		return null;
	}
	
	public String blockDSLogonAccess() {
		if(getReasonText().length() > 0) {
			setReasonTextEntered("true");
			setBlockAccess(true);
			setShowBlock(true);
			setShowUnblock(false);
		} else {
			setReasonTextEntered("false");
			setShowUnblock(false);
			setShowBlock(true);
		}
		return null;
	}
	
	public String unblockDSLogonAccess() {
		if(getReasonText().length() > 0) {
			setReasonTextEntered("true");
			setBlockAccess(false);
			setShowUnblock(true);
			setShowBlock(false);
		} else {
			setReasonTextEntered("false");
			setShowBlock(false);
			setShowUnblock(true);
		}
		return null;
	}
	
	public String confirmCancel(){
		setReasonTextEntered("");
		return null;
	}
	
	public boolean getShowBlock() {
		return showBlock;
	}

	public void setShowBlock(boolean showBlock) {
		this.showBlock = showBlock;
	}
	
	public boolean getShowUnblock() {
		return showUnblock;
	}

	public void setShowUnblock(boolean showUnblock) {
		this.showUnblock = showUnblock;
	}

	public Long getUserprofileId() {
		return userprofileId;
	}

	public void setUserprofileId(Long userprofileId) {
		this.userprofileId = userprofileId;
	}

	public boolean isBlockAccess() {
		return blockAccess;
	}

	public void setBlockAccess(boolean blockAccess) {
		this.blockAccess = blockAccess;
	}
	
	public String getReasonText() {
		return reasonText;
	}

	public void setReasonText(String reasonText) {
		this.reasonText = reasonText;
	}
	
	public String getReasonTextEntered() {
		return reasonTextEntered;
	}

	public void setReasonTextEntered(String reasonTextEntered) {
		this.reasonTextEntered = reasonTextEntered;
	}
	
	public String getLiferayUserId() {
		return liferayUserId;
	}

	public void setLiferayUserId(String liferayUserId) {
		this.liferayUserId = liferayUserId;
	}
}
